<?php
/*

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

 Interface file for SonicBlue Rio Receiver integration.
 Written by Jon C. Hodgson - ampache@jonq.com
 v0.1 - 2004.07.28

*/

// These conversion functions compensate for the fact that rio FIDs could be either a track or playlist
// based on their range, as well as deal with the special '100' FID. It offsets all track IDs by 101
// and offsets all playlist IDs by 16777115, chosen simply so that you could tell a playlist by looking
// at it's hex value.





// Setup conf parameters as global
global $hide_private_playlists;
global $filter_from_beginning;

// Defaults;
$hide_private_playlists=0;
$filter_from_beginning=1;


// Read in config settings
$fh = fopen ('rio.conf', 'r') or die('Could not open config file');

while ($line = fgets($fh))
{

        
        // Look for known parameters
        if (preg_match("/^\s*hide_private_playlists\s*=\s*([0|1])\s*$/i",$line,$matches)) {$hide_private_playlists=$matches[1]; }
        elseif (preg_match("/^\s*filter_from_beginning\s*=\s*([0|1])\s*$/i",$line,$matches)) {$filter_from_beginning=$matches[1]; }
        
}

fclose($fh);




// TODO: Add input validation 
// TODO: Verify that TrackID < 16777014 ($playlist_add-$track_add)


// A FID can be up to      0xFFFFFFFF
//                    ID   0xFID
// Track               0 = 0x00000065
// Track     268,435,253 = 0x0FFFFF9a
// Playlist            0 = 0x10000000
// Playlist  268,435,354 = 0x1FFFFF9a
// Special             0 = 0x20000000
// Special 3,758,096,383 = 0xFFFFFFFF


// Amount to add to a track to protect special keyword 100
$track_add=101;

// Amount to add to a playlist to make 0=0x10000000
$playlist_add=268435355;

// Amount to add to a playlist to make 0=0x20000000
$special_add=536870811;





// Track Functions
// ---------------

function rio_track2pfid ($track) {
	global $track_add;
	return pack("L",$track+$track_add);
}

function rio_pfid2track ($pfid) {
	global $track_add;	
	$array=unpack("L*",$pfid);
	return $array[1]-$track_add;
}

function rio_track2fid ($track) {
	global $track_add;	
	return dechex($track+$track_add);
}

function rio_fid2track ($fid) {
	global $track_add;	
	return hexdec($fid)-$track_add;	
}





// Playlist Functions
// ------------------

function rio_playlist2pfid ($playlist) {
	global $playlist_add;
	return rio_track2pfid($playlist+$playlist_add);
}

function rio_pfid2playlist ($pfid) {
	global $playlist_add;
	return rio_pfid2track($pfid)-$playlist_add;
}

function rio_playlist2fid ($playlist) {
	global $playlist_add;	
	return rio_track2fid($playlist+$playlist_add);
}

function rio_fid2playlist ($fid) {
	global $playlist_add;
	return rio_fid2track($fid)-$playlist_add;	
}





// Special Functions
// -----------------

function rio_special2pfid ($special) {
	global $special_add;
	return rio_track2pfid($special+$special_add);
}

function rio_pfid2special ($pfid) {
	global $special_add;
	return rio_pfid2track($pfid)-$special_add;
}

function rio_special2fid ($special) {
	global $special_add;	
	return rio_track2fid($special+$special_add);
}

function rio_fid2special ($fid) {
	global $special_add;
	return rio_fid2track($fid)-$special_add;	
}





// FID id functions
// ----------------

function rio_isTrack($fid) {
	global $playlist_add;
	return hexdec($fid) < $playlist_add;	
}

function rio_isPlaylist($fid) {
	global $playlist_add;
	global $special_add;
	return (hexdec($fid) >= $playlist_add && hexdec($fid) < $special_add);	
}

function rio_isSpecial($fid) {
	global $special_add;
	return hexdec($fid) >= $special_add;	
}





// encode tag data
// ---------------

function rio_tagdata($key,$data) {

	$data=trim($data);

	if ($data=="") {
		
		return;
		
	} else {

		return pack("CCa*",$key,strlen($data),$data);
		
	}
}


?>